set more off

clear

capture log close


cd "/Users/admin/Documents/Publications/2015_JOP/Data/Localities"
log using /Users/admin/Documents/Publications/2015_JOP/Logs/HD_December_28_2014.log, replace


use replication_data_JOP2015.dta, replace


********************************************
***** Summary Statistics               *****
********************************************
******************************
**** TABLE 1: by year     ****
******************************

preserve

sort year
collapse (sum) punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm terrorist fatalities, by (year)

sort year
by year: sum  punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm terrorist fatalities


restore


**************************************
**** TABLE A.1: All localities    ****
**************************************

sort locality_id
by locality_id: egen sum_tk = sum(tk)
by locality_id: egen sum_cod = sum(cod)

sum sum_fut_ter sum_fatalities sum_tk sum_cod if count == 1


sum sum_punishment sum_security sum_pun_units  sum_sec_units sum_pun_res sum_sec_res sum_pun_area sum_sec_area    if count == 1 

 
******************************************
**** TABLE A.2: Localities with ST    ****
******************************************

sort sum_fut_ter_pos

by sum_fut_ter_pos: sum  sum_fut_ter sum_fatalities sum_tk sum_cod   if count == 1, d
by sum_fut_ter_pos: sum  sum_punishment sum_security sum_pun_units sum_sec_units sum_pun_res sum_sec_res sum_pun_area sum_sec_area  if count == 1, d



********************************************************
**** TABLE A.3: Economic and Demographic Variables  ****
********************************************************

preserve

sort district
collapse (mean) unemployed work_israel yerschol age married lfs_male curfew (sum) terrorist fatalities other_fat tk cod housedemolition numberofhousingunits /* 
  */ residentsperunits areainm punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm, by (district)

sum age lfs_male married yerschol unemployed work_israel curfew, d



***************
****  MAP  ****
***************

sort district
by district: sum terrorist punishment   

restore



***********************************
*** District:    Regressions   ****
***********************************
preserve

sort district month_id

collapse (sum) fut_terrorist terrorist housedemolition numberofhousingunits residentsperunits areainm /*
  */ punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm /*
  */ fatalities other_fat tk cod all_tk retal_pun pun_ST pun_units_ST pun_residents_ST pun_areainm_ST pun_NST pun_units_NST pun_residents_NST pun_areainm_NST /*
  */ (mean) wbgs unemployed work_israel yerschol age married lfs_male year curfew, by (district month_id)

replace security = . if year < 2004 
replace sec_units = . if year < 2004 
replace sec_residents = . if year < 2004
replace sec_areainhm = . if year < 2004

sort district month_id
by district: gen fut_curfews = curfew[_n+1]
replace fut_curfews =. if month_id == 75
replace fut_curfews = curfew if month_id == 63


sort district month_id
foreach var of varlist punishment pun_units pun_residents pun_areainhm {
by district: gen fut_`var' = `var'[_n+1]
replace fut_`var' =. if month_id == 75
}


**********************************
****  TABLE 2 - Punitive HD   ****
**********************************

xi: poisson fut_terrorist punishment , cl(district)
xi: poisson fut_terrorist punishment i.year, cl(district)
xi: poisson fut_terrorist punishment i.district, cl(district)
xi: poisson fut_terrorist punishment i.year i.district, cl(district)
xi: poisson fut_terrorist punishment unemployed work_israel yerschol age  married lfs_male i.year i.district, cl(district)
xi: poisson fut_terrorist punishment unemployed work_israel yerschol age  married lfs_male other_fat tk cod i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist punishment unemployed work_israel yerschol age  married lfs_male other_fat tk cod fut_curfews i.year i.district, cl(district)


**************************************************************
****  TABLE A.4 - Other Proxies ****
***************************************************************


**********************     
***  UNITS   ***
**********************


xi: poisson fut_terrorist pun_units i.year i.district, cl(district)
xi: poisson fut_terrorist pun_units unemployed work_israel yerschol age married lfs_male i.year i.district, cl(district)
xi: poisson fut_terrorist pun_units unemployed work_israel yerschol age married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_units unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district,cl(district)


**************************
***  RESIDENTS  ***
**************************

xi: poisson fut_terrorist pun_residents i.year i.district, cl(district)
xi: poisson fut_terrorist pun_residents unemployed work_israel yerschol age  married lfs_male i.year i.district, cl(district)
xi: poisson fut_terrorist pun_residents unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_residents unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)


***************************
***        AREA         ***
***************************

xi: poisson fut_terrorist pun_areainhm i.year i.district, cl(district)
xi: poisson fut_terrorist pun_areainhm unemployed work_israel yerschol age  married lfs_male i.year i.district, cl(district)
xi: poisson fut_terrorist pun_areainhm unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_areainhm unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)




********************************************************
*** TABLE A.9: Geographic Effects                    ***
********************************************************

sort wbgs month_id

by wbgs month_id: egen reg_punishment    = sum (punishment)
by wbgs month_id: egen reg_pun_units     = sum (pun_units)
by wbgs month_id: egen reg_pun_res       = sum (pun_residents)
by wbgs month_id: egen reg_pun_area      = sum (pun_areainhm)
by wbgs month_id: egen reg_tk            = sum (tk)
by wbgs month_id: egen reg_cod           = sum (cod)
by wbgs month_id: egen reg_other_fat     = sum (other_fat)


gen ND_pun          = reg_punishment - punishment
gen ND_pun_units    = reg_pun_units - pun_units
gen ND_pun_residen  = reg_pun_res - pun_residents
gen ND_pun_area     = reg_pun_area - pun_areainhm

gen ND_tk = reg_tk - tk
gen ND_cod = reg_cod - cod
gen ND_other_fat = reg_other_fat - other_fat

***************************
*** Neigh  DEMOLITIONS  ***
***************************

xi: poisson fut_terrorist punishment ND_pun unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist punishment ND_pun unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)


***************************
*** Neigh  UNITS        ***
***************************

xi: poisson fut_terrorist pun_units ND_pun_units unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_units ND_pun_units unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)


***************************
*** Neigh  RESIDENTS    ***
***************************

xi: poisson fut_terrorist pun_residents ND_pun_residen unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_residents ND_pun_residen unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)

***************************
*** Neigh  AREA         ***
***************************

xi: poisson fut_terrorist pun_areainhm ND_pun_area unemployed work_israel yerschol age  married lfs_male i.year i.district i.district*year, cl(district)
xi: poisson fut_terrorist pun_areainhm ND_pun_area unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)



restore



**********************************************************
***                    TABLE 3                         ***
**********************************************************


foreach var of varlist pun_ST pun_units_ST pun_residents_ST pun_areainm_ST pun_NST pun_units_NST pun_residents_NST pun_areainm_NST {
replace `var' = 0 if `var' ==.
}

sort district month_id
foreach var of varlist pun_ST pun_units_ST pun_residents_ST pun_areainm_ST pun_NST pun_units_NST pun_residents_NST pun_areainm_NST {
by district month_id: egen district_`var' = sum(`var')
}


sort district month_id
by district month_id: egen district_pun = sum(punishment)
by district month_id: egen district_pun_units = sum(pun_units)
by district month_id: egen district_pun_res = sum(pun_residents)
by district month_id: egen district_pun_area = sum(pun_areainhm)


sort locality_id month_id
by locality_id: gen fut_curfews = curfew[_n+1]
replace fut_curfews =. if month_id == 75
replace fut_curfews = curfew if month_id == 63


sort locality_id month_id
foreach var of varlist district_pun district_pun_units district_pun_res district_pun_area punishment pun_units pun_residents pun_areainhm  {

by locality_id: gen fut_`var' = `var'[_n+1]
replace fut_`var' =. if month_id == 75

}

xi: poisson fut_terrorist district_pun, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year, cl(locality_id)


preserve
 
drop if sum_fut_ter == 0

xi: poisson fut_terrorist district_pun i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)

xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male other_fat tk cod i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male other_fat tk cod fut_curfews, cl(locality_id)



********************************************************
***                      TABLE 5                     ***
********************************************************


xi: poisson fut_terrorist terrorist district_pun i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male fatalities i.district*year, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun i.year i.locality_id work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)

xi: xtabond  fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male  i.district*year,              vce(robust)
xi: xtdpdsys  fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male ,             vce(robust)



xi: poisson fut_terrorist terrorist district_pun_units i.year i.locality_id, cl(locality_id) 
xi: poisson fut_terrorist terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id) 
xi: poisson fut_terrorist terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id) 
xi: poisson fut_terrorist terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id) 

xi: xtabond  fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male  i.district*year,              vce(robust)
xi: xtdpdsys  fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male ,             vce(robust)



xi: poisson fut_terrorist terrorist district_pun_res i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
  
xi: xtabond  fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male  i.district*year,              vce(robust)
xi: xtdpdsys  fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male ,             vce(robust)

xi: poisson fut_terrorist terrorist district_pun_area i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)

xi: xtabond  fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male  i.district*year,              vce(robust)
xi: xtdpdsys  fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male  i.district*year,             vce(robust)


*****************************************
****  Table A.10: REVERSE CAUSALITY  ****
*****************************************
 
xi: poisson fut_punishment terrorist            i.year i.locality_id unemployed work_israel yerschol age married lfs_male             , cl(locality_id)
xi: poisson fut_punishment terrorist            i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
xi: poisson fut_punishment terrorist punishment i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)

xi: xtabond  fut_punishment terrorist i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews,              vce(robust)
xi: xtdpdsys fut_punishment terrorist i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews,             vce(robust)


xi: poisson fut_pun_areainhm terrorist              i.year i.locality_id, cl(locality_id)
xi: poisson fut_pun_areainhm terrorist              i.year i.locality_id unemployed work_israel yerschol age married lfs_male fatalities            , cl(locality_id)
xi: poisson fut_pun_areainhm terrorist              i.year i.locality_id unemployed work_israel yerschol age married lfs_male fatalities fut_curfews, cl(locality_id)
xi: poisson fut_pun_areainhm terrorist pun_areainhm i.year i.locality_id unemployed work_israel yerschol age married lfs_male fatalities fut_curfews, cl(locality_id)

xi: poisson fut_pun_areainhm terrorist              i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
xi: poisson fut_pun_areainhm terrorist pun_areainhm i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)


xi: xtabond  fut_pun_areainhm terrorist i.year i.locality_id unemployed work_israel yerschol age married lfs_male ,              vce(robust)
xi: xtdpdsys fut_pun_areainhm terrorist i.year i.locality_id unemployed work_israel yerschol age married lfs_male ,             vce(robust)

*/


restore




**********************************************************
***                  TABLE A.5                        ***
**********************************************************


preserve
drop if sum_fut_ter == 0

xi: poisson fut_terrorist district_pun_units i.year i.locality_id, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id) 


xi: poisson fut_terrorist district_pun_res i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
  
xi: poisson fut_terrorist district_pun_area i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)




**********************************************************
***                    TABLE 4                         ***
**********************************************************

*** excluding observations where there was an attack and a retaliatory demolishion in the same locality * month

sort year month
list year month locality_id if retal_pun > 0

corr fut_terrorist terrorist district_pun fatalities fut_curfews

sort retal_pun
by retal_pun: corr terrorist district_pun fatalities fut_curfews

sort retal_pun
by retal_pun: pwcorr terrorist district_pun fatalities fut_curfews, sig listwise


drop if retal_pun > 0

xi: poisson fut_terrorist district_pun i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)


xi: poisson fut_terrorist district_pun_units i.year i.locality_id, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id) 
xi: poisson fut_terrorist district_pun_units i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id) 

xi: poisson fut_terrorist district_pun_res i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun_res i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
 
xi: poisson fut_terrorist district_pun_area i.year i.locality_id, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male i.district*year, cl(locality_id)
xi: poisson fut_terrorist district_pun_area i.year i.locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)


restore      


***************************************************
*** District:    GRAPHS  -- Punitive only      ****
***************************************************

preserve

sort district month_id

collapse (sum) fut_terrorist terrorist housedemolition numberofhousingunits residentsperunits areainm /*
  */ punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm /*
  */ fatalities /*
  */ (mean) wbgs unemployed work_israel yerschol age married lfs_male year curfew, by (district month_id)

sort district month_id
by district: gen fut_curfews = curfew[_n+1]
replace fut_curfews =. if month_id == 75


sort district month_id

by district: gen punishment_1 = punishment[_n-1]
by district: gen punishment_2 = punishment_1[_n-1]
by district: gen punishment_3 = punishment_2[_n-1]
by district: gen punishment_4 = punishment_3[_n-1]
by district: gen punishment_5 = punishment_4[_n-1]
by district: gen punishment_6 = punishment_5[_n-1]

gen punishment_11 = punishment_1
gen punishment_12 = punishment_1 + punishment_2
gen punishment_13 = punishment_12 + punishment_3
gen punishment_14 = punishment_13 + punishment_4
gen punishment_15 = punishment_14 + punishment_5
gen punishment_16 = punishment_15 + punishment_6

by district: gen pun_units_1 = pun_units[_n-1]
by district: gen pun_units_2 = pun_units_1[_n-1]
by district: gen pun_units_3 = pun_units_2[_n-1]
by district: gen pun_units_4 = pun_units_3[_n-1]
by district: gen pun_units_5 = pun_units_4[_n-1]
by district: gen pun_units_6 = pun_units_5[_n-1]

gen pun_units_11 = pun_units_1
gen pun_units_12 = pun_units_11 + pun_units_2
gen pun_units_13 = pun_units_12 + pun_units_3
gen pun_units_14 = pun_units_13 + pun_units_4
gen pun_units_15 = pun_units_14 + pun_units_5
gen pun_units_16 = pun_units_15 + pun_units_6

by district: gen pun_residents_1 = pun_residents[_n-1]
by district: gen pun_residents_2 = pun_residents_1[_n-1]
by district: gen pun_residents_3 = pun_residents_2[_n-1]
by district: gen pun_residents_4 = pun_residents_3[_n-1]
by district: gen pun_residents_5 = pun_residents_4[_n-1]
by district: gen pun_residents_6 = pun_residents_5[_n-1]

gen pun_residents_11 = pun_residents_1
gen pun_residents_12 = pun_residents_11 + pun_residents_2
gen pun_residents_13 = pun_residents_12 + pun_residents_3
gen pun_residents_14 = pun_residents_13 + pun_residents_4
gen pun_residents_15 = pun_residents_14 + pun_residents_5
gen pun_residents_16 = pun_residents_15 + pun_residents_6

by district: gen pun_areainhm_1 = pun_areainhm[_n-1]
by district: gen pun_areainhm_2 = pun_areainhm_1[_n-1]
by district: gen pun_areainhm_3 = pun_areainhm_2[_n-1]
by district: gen pun_areainhm_4 = pun_areainhm_3[_n-1]
by district: gen pun_areainhm_5 = pun_areainhm_4[_n-1]
by district: gen pun_areainhm_6 = pun_areainhm_5[_n-1]

gen pun_areainhm_11 = pun_areainhm_1
gen pun_areainhm_12 = pun_areainhm_11 + pun_areainhm_2 
gen pun_areainhm_13 = pun_areainhm_12 + pun_areainhm_3
gen pun_areainhm_14 = pun_areainhm_13 + pun_areainhm_4
gen pun_areainhm_15 = pun_areainhm_14 + pun_areainhm_5
gen pun_areainhm_16 = pun_areainhm_15 + pun_areainhm_6

order district month_id fatalities punishment punishment_1 punishment_2 punishment_3 punishment_4 punishment_5 punishment_6
   
sort district month_id
by district: gen unemployed_1 = unemployed[_n-1]
by district: gen work_israel_1 = work_israel[_n-1]
by district: gen yerschol_1 = yerschol[_n-1]
by district: gen age_1 = age[_n-1]
by district: gen married_1 = married[_n-1]
by district: gen male_1 = lfs_male[_n-1]
by district: gen fatalities_1 = fatalities[_n-1]
by district: gen curfew_1 = curfew[_n-1]



*** Punitive DEMOLITIONS ***

gen coef_punishment = .
gen se_punishment = .
gen upb_punishment = .
gen lob_punishment = .

gen month_lag = .     
     

forvalues j = 1/6 {
xi: poisson terrorist punishment_1`j' unemployed_1 work_israel_1 yerschol_1 age_1 married_1 male_1  /*
     */  i.year i.district, cl(district) irr

replace coef_punishment = exp(_b[punishment_1`j']) in `j'
replace se_punishment = _se[punishment_1`j'] in `j'
replace upb_punishment = coef_punishment + 1.645*se_punishment in `j'
replace lob_punishment = coef_punishment - 1.645*se_punishment in `j'
replace month_lag = `j' in `j'

}

gen yone = 1  

twoway  (rarea lob_punishment upb_punishment month_lag, sort bcolor(gs14) mcolor(blue)) /* 
   */   (connected coef_punishment month_lag, sort lcolor(blue) mcolor(blue))  /* 
   */   (connected yone month_lag, sort lcolor(black) msymbol(i) mcolor(black)) , /*
   */   legend(off) xtitle("Months") title(Houses)  saving(Figure_a, replace) 



     
*** UNITS ***
     
gen coef_pun_units = .
gen se_pun_units = .
gen upb_pun_units = .
gen lob_pun_units = .
     

forvalues j = 1/6 {
xi: poisson terrorist pun_units_1`j' unemployed_1 work_israel_1 yerschol_1 age_1 married_1 male_1  /*
     */  i.year i.district, cl(district)

replace coef_pun_units = exp(_b[pun_units_1`j']) in `j'
replace se_pun_units = _se[pun_units_1`j'] in `j'
replace upb_pun_units = coef_pun_units + 1.645*se_pun_units in `j'
replace lob_pun_units = coef_pun_units - 1.645*se_pun_units in `j'
replace month_lag = `j' in `j'

}
 
 

twoway  (rarea lob_pun_units upb_pun_units month_lag, sort bcolor(gs14) mcolor(blue)) /* 
   */   (connected coef_pun_units month_lag, sort lcolor(blue) mcolor(blue))  /* 
   */   (connected yone month_lag, sort lcolor(black) msymbol(i) mcolor(black)) , /*
   */   legend(off) xtitle("Months") title(Apartment Units)  saving(Figure_b, replace) 

     

*** RESIDENTS ***
     
gen coef_pun_residents = .
gen se_pun_residents = .
gen upb_pun_residents = .
gen lob_pun_residents = .
     

forvalues j = 1/6 {
xi: poisson terrorist pun_residents_1`j' unemployed_1 work_israel_1 yerschol_1 age_1 married_1 male_1  /*
     */  i.year i.district, cl(district)

replace coef_pun_residents = exp(_b[pun_residents_1`j']) in `j'
replace se_pun_residents = _se[pun_residents_1`j'] in `j'
replace upb_pun_residents = coef_pun_residents + 1.645*se_pun_residents in `j'
replace lob_pun_residents = coef_pun_residents - 1.645*se_pun_residents in `j'
replace month_lag = `j' in `j'

}


twoway  (rarea lob_pun_residents upb_pun_residents month_lag, sort bcolor(gs14) mcolor(blue)) /* 
   */   (connected coef_pun_residents month_lag, sort lcolor(blue) mcolor(blue))  /* 
   */   (connected yone month_lag, sort lcolor(black) msymbol(i) mcolor(black)) , /*
   */   legend(off) xtitle("Months") title(Residents in Demolished Houses)  saving(Figure_c, replace) 

    
     
*** AREA ***
    
gen coef_pun_areainhm = .
gen se_pun_areainhm = .
gen upb_pun_areainhm = .
gen lob_pun_areainhm = .

forvalues j = 1/6 {
xi: poisson terrorist pun_areainhm_1`j' unemployed_1 work_israel_1 yerschol_1 age_1 married_1 male_1  /*
     */  i.year i.district, cl(district)

replace coef_pun_areainhm = exp(_b[pun_areainhm_1`j']) in `j'
replace se_pun_areainhm = _se[pun_areainhm_1`j'] in `j'
replace upb_pun_areainhm = coef_pun_areainhm + 1.645*se_pun_areainhm in `j'
replace lob_pun_areainhm = coef_pun_areainhm - 1.645*se_pun_areainhm in `j'
replace month_lag = `j' in `j'

}

      
twoway  (rarea lob_pun_areainhm upb_pun_areainhm month_lag, sort bcolor(gs14) mcolor(blue)) /* 
   */   (connected coef_pun_areainhm month_lag, sort lcolor(blue) mcolor(blue))  /* 
   */   (connected yone month_lag, sort lcolor(black) msymbol(i) mcolor(black)) , /*
   */   legend(off) xtitle("Months", height(8)) title(Size of Houses Demolished)  saving(Figure_d, replace) 
     
gr combine figure_a.gph figure_b.gph figure_c.gph figure_d.gph, saving(Figure1, replace)

restore
     



*****************************************************************************************
*****************************************************************************************
*****************************************************************************************

********** PRECAUTIONARY DEMOLITIONS & punitive

*****************************************************************************************
*****************************************************************************************
*****************************************************************************************


***********************************
*** District:    Regressions   ****
***********************************
preserve

sort district month_id

collapse (sum) fut_terrorist terrorist housedemolition numberofhousingunits residentsperunits areainm /*
  */ punishment pun_units pun_residents pun_areainhm security sec_units sec_residents sec_areainhm /*
  */ fatalities tk cod other_fat/*
  */ (mean) wbgs unemployed work_israel yerschol age married lfs_male year curfew, by (district month_id)

replace security = . if year < 2004 
replace sec_units = . if year < 2004 
replace sec_residents = . if year < 2004
replace sec_areainhm = . if year < 2004

sort district month_id
by district: gen fut_curfews = curfew[_n+1]
replace fut_curfews =. if month_id == 75
replace fut_curfews = curfew if month_id == 63




**********************************
****        TABLE 6           ****
**********************************

**********************     
***    HOUSES      ***
**********************

xi: poisson fut_terrorist security unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)
xi: poisson fut_terrorist security unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district if district < 15.5, cl(district)

     
**********************     
***  UNITS   ***
**********************

xi: poisson fut_terrorist sec_units unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district,cl(district)
xi: poisson fut_terrorist sec_units unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district if district < 15.5,cl(district)


**************************
***  RESIDENTS  ***
**************************

xi: poisson fut_terrorist sec_residents unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)
xi: poisson fut_terrorist sec_residents unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district if district < 15.5, cl(district)


***************************
***        AREA         ***
***************************

xi: poisson fut_terrorist sec_areainhm unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district, cl(district)
xi: poisson fut_terrorist sec_areainhm unemployed work_israel yerschol age  married lfs_male tk cod other_fat fut_curfews i.year i.district if district < 15.5, cl(district)

restore


sort district month_id
by district month_id: egen district_sec = sum(security)
by district month_id: egen district_sec_units = sum(sec_units)
by district month_id: egen district_sec_res = sum(sec_residents)
by district month_id: egen district_sec_areainhm = sum(sec_areainhm)

replace district_sec = . if year < 2004 
replace district_sec_units = . if year < 2004 
replace district_sec_res = . if year < 2004
replace district_sec_area = . if year < 2004

preserve
 
drop if sum_fut_ter == 0

xi: poisson fut_terrorist district_sec i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
xi: poisson fut_terrorist district_sec i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews if district ~=16, cl(locality_id)
	
xi: poisson fut_terrorist district_sec_units i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id) 
xi: poisson fut_terrorist district_sec_units i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews if district ~=16, cl(locality_id) 
 
xi: poisson fut_terrorist district_sec_res i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
xi: poisson fut_terrorist district_sec_res i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews if district ~=16, cl(locality_id)
  
xi: poisson fut_terrorist district_sec_areainhm i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews, cl(locality_id)
xi: poisson fut_terrorist district_sec_areainhm i.year locality_id unemployed work_israel yerschol age married lfs_male tk cod other_fat fut_curfews if district~=16, cl(locality_id)

restore

